<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
 
use App\Invoice;

use Session;
use File;
 
use App\Exports\InvoiceExport;
use App\Imports\InvoiceImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;

use Illuminate\Filesystem\Filesystem;

class InvoiceController extends Controller
{

	public function home(){
		return view('index');
	}

    public function index()
	{
		$invoice = Invoice::all();
		return view('invoice',compact('invoice'));
	}
 
	public function export_excel()
	{
		return Excel::download(new InvoiceExport, 'invoice.xlsx');
	}

	public function import_excel(Request $request) 
	{
		// validasi
		/*
		$this->validate($request, [
			'file' => 'required|mimes:csv,xls,xlsx'
		]);
		*/
 
		// menangkap file excel
		$file = $request->file('file');
 
		// membuat nama file unik
		$nama_file = date('Ymd_His_').$file->getClientOriginalName();
 
		// upload ke folder file_invoice di dalam folder public
		$file->move('file_invoice',$nama_file);
 
		// import data
		Excel::import(new InvoiceImport, public_path('/file_invoice/'.$nama_file));
 
		// notifikasi dengan session
		Session::flash('sukses','Data Siswa Berhasil Diimport!');




		


		/*
		*
		* ADD GENERAL DATA
		*
		*/

		$no_faktur = DB::table('invoice')->where('FIELD_1', 'LIKE', '%FAKTUR%')->get();
		foreach($no_faktur as $this_no_faktur){
			$this_no_faktur = $this_no_faktur->FIELD_3;
		}
		$tanggal = DB::table('invoice')->where('FIELD_1', 'LIKE', '%TANGGAL%')->get();
		foreach($tanggal as $this_tanggal){
			$this_tanggal = $this_tanggal->FIELD_3;
		}
		$customer = DB::table('invoice')->where('FIELD_1', 'LIKE', '%KEPADA%')->get();
		foreach($customer as $this_customer){
			$this_customer = $this_customer->FIELD_3;
		}
		$jumlah = DB::table('invoice')->where('FIELD_1', 'LIKE', '%JUMLAH%')->get();
		foreach($jumlah as $this_jumlah){
			$total_item = $this_jumlah->FIELD_5;
			$total_bruto = $this_jumlah->FIELD_6;
		}
		$disc = DB::table('invoice')->where('FIELD_1', 'LIKE', '%DISC%')->get();
		foreach($disc as $this_disc){
			$this_disc = $this_disc->FIELD_6;
		}
		$ongkir = DB::table('invoice')->where('FIELD_1', 'LIKE', '%ONGKOS%')->get();
		foreach($ongkir as $this_ongkir){
			$this_ongkir = $this_ongkir->FIELD_6;
		}
		if( $this_ongkir > 0 ){

		} else {
			$this_ongkir = 0;
		}
		$netto = DB::table('invoice')->where('FIELD_1', 'LIKE', '%NETTO%')->get();
		foreach($netto as $this_netto){
			$this_netto = $this_netto->FIELD_6;
		}

		DB::table('report_general')->insert([
			"NO_FAKTUR" => $this_no_faktur,
			"CUSTOMER" => $this_customer,
			"TOTAL_ITEM" => $total_item,
			"JUMLAH" => $total_bruto,
			"DISC_RUPIAH" => $this_disc,
			"ONGKOS_KIRIM" => $this_ongkir,
			"NETTO" => $this_netto,
			"DATE_CREATED" => date('Y-m-d H:i:s')
		]);



		/*
		*
		* ADD DETAIL DATA
		*
		*/
		
		$item_detail = DB::table('invoice')->where('FIELD_4', '>', 0)->get();
		foreach($item_detail as $this_item_detail){

			DB::table('report_detail')->insert([
				"NO_FAKTUR" => $this_no_faktur,
				"CUSTOMER" => $this_customer,
				"JUDUL_BUKU" => $this_item_detail->FIELD_2,
				"HARGA_SATUAN" => $this_item_detail->FIELD_3,
				"DISC" => $this_item_detail->FIELD_4,
				"EXP" => $this_item_detail->FIELD_5,
				"JUMLAH_DETAIL" => $this_item_detail->FIELD_6,
				"DATE_CREATED" => date('Y-m-d H:i:s')
			]);

		}



		/*
		*
		* TRUNCATE TABLE INVOICE
		*
		*/
		DB::select(DB::raw('truncate table invoice'));



 
		// alihkan halaman kembali
		// return redirect('/invoice');
		return redirect('/home');
	}

	public function DeleteAllSources(){

		$file = new Filesystem;
		$file->cleanDirectory('file_invoice');

		return redirect('/home');

	}

	public function AnalyseData(){

		ini_set('max_execution_time', 3000);

		// DB::select(DB::raw('truncate table report_general'));
		// DB::select(DB::raw('truncate table report_detail'));

		$filesInFolder = \File::files('file_invoice');  

		if( count($filesInFolder) > 0 ){
			foreach($filesInFolder as $path) { 
	          	$file = pathinfo($path);
	          	$filename = $file['basename'] ;

	          	// import data
				Excel::import(new InvoiceImport, public_path('/file_invoice/'.$filename));


				/*
				*
				* ADD GENERAL DATA
				*
				*/

				$no_faktur = DB::table('invoice')->where('FIELD_1', 'LIKE', '%FAKTUR%')->get();
				foreach($no_faktur as $this_no_faktur){
					$this_no_faktur = $this_no_faktur->FIELD_3;
				}
				$tanggal = DB::table('invoice')->where('FIELD_1', 'LIKE', '%TANGGAL%')->get();
				foreach($tanggal as $this_tanggal){
					$this_tanggal = $this_tanggal->FIELD_3;
				}
				$customer = DB::table('invoice')->where('FIELD_1', 'LIKE', '%KEPADA%')->get();
				foreach($customer as $this_customer){
					$this_customer = $this_customer->FIELD_3;
				}
				$jumlah = DB::table('invoice')->where('FIELD_1', 'LIKE', '%JUMLAH%')->orWhere('FIELD_4', 'LIKE', '%JUMLAH%')->get();
				foreach($jumlah as $this_jumlah){
					$total_item = $this_jumlah->FIELD_5;
					$total_bruto = $this_jumlah->FIELD_6;
				}
				$disc = DB::table('invoice')->where('FIELD_1', 'LIKE', '%DISC%')->orWhere('FIELD_4', 'LIKE', '%DISC%')->get();
				foreach($disc as $this_disc){
					$this_disc = $this_disc->FIELD_6;
				}
				$ongkir = DB::table('invoice')->where('FIELD_1', 'LIKE', '%ONGKOS%')->orWhere('FIELD_4', 'LIKE', '%ONGKOS%')->get();
				// print_r($ongkir);exit;
				foreach($ongkir as $this_ongkir){
					$this_ongkir = $this_ongkir->FIELD_6;
				}
				if( $this_ongkir > 0 ){
					// $this_ongkir = $this_ongkir->FIELD_6;
				} else {
					$this_ongkir = 0;
				}
				$netto = DB::table('invoice')->where('FIELD_1', 'LIKE', '%NETTO%')->orWhere('FIELD_4', 'LIKE', '%NETTO%')->get();
				foreach($netto as $this_netto){
					$this_netto = $this_netto->FIELD_6;
					$sanitize_netto = str_replace(",",".", $this_netto);
				}

				$sanitize_total_item = str_replace(",", ".", $total_item);

				$sanitize_jumlah = str_replace(",", "", $total_bruto);
				$sanitize_jumlah = str_replace(".", "", $sanitize_jumlah);

				$sanitize_disc_rupiah = str_replace(",", ".", $this_disc);
				$sanitize_ongkos_kirim = str_replace(",", ".", $this_ongkir);
				$sanitize_netto = str_replace(",", ".", $sanitize_netto);

				DB::table('report_general')->insert([
					"NO_FAKTUR" => $this_no_faktur,
					"CUSTOMER" => $this_customer,
					"TOTAL_ITEM" => 0,
					"JUMLAH" => $sanitize_jumlah,
					"DISC_RUPIAH" => $this_disc,
					"ONGKOS_KIRIM" => $this_ongkir,
					"NETTO" => 0,
					"DATE_CREATED" => date('Y-m-d H:i:s')
				]);
				$new_report_general_id = DB::getPDO()->lastInsertId();





				/*
				*
				* ADD DETAIL DATA
				*
				*/
				
				$item_detail = DB::table('invoice')->where('FIELD_4', '>', 0)->get();
				$temp_total_item = 0;
				foreach($item_detail as $this_item_detail){

					$sanitize_disc = str_replace(",", ".", $this_item_detail->FIELD_4);

					$jumlah_row_satuan = $this_item_detail->FIELD_3 * $this_item_detail->FIELD_5;

					DB::table('report_detail')->insert([
						"NO_FAKTUR" => $this_no_faktur,
						"CUSTOMER" => $this_customer,
						"JUDUL_BUKU" => $this_item_detail->FIELD_2,
						"HARGA_SATUAN" => $this_item_detail->FIELD_3,
						"DISC" => $sanitize_disc,
						"EXP" => $this_item_detail->FIELD_5,
						"JUMLAH_DETAIL" => $jumlah_row_satuan,
						"DATE_CREATED" => date('Y-m-d H:i:s')
					]);

					$temp_total_item++;

				}



				/*
				*
				* UPDATE TOTAL ITEM
				*
				*/
				DB::table('report_general')->where('ID', $new_report_general_id)->update([
					"TOTAL_ITEM" => $temp_total_item
				]);




				/*
				*
				* TRUNCATE TABLE INVOICE
				*
				*/
				DB::select(DB::raw('truncate table invoice'));

				File::delete(public_path('/file_invoice/'.$filename));
	     	} 
		}

    	

     	$detail_report = DB::table('report_detail')->get()->toJSON();
     	file_put_contents(base_path('/public/json_detail/source.json'), stripslashes($detail_report));


     	return redirect('/home');

	}

}
